# 마방진이란?

마방진이란 모든 행, 열, 주대각선과 일반적으로 다른 대각선의 일부 혹은 모든 대각선 방향으로 수를 모두 더하면 그 합이 같도록 배열된 고유한 정수를 포함하는 정사각형으로 정의한다.

# 마방진 공식

`n`차 마방진은 일반적으로 `n²`개의 고유한 정수 숫자들을 정사각형 안에 정리한 것이다. 모든 행, 열, 대각선의 `n` 개의 숫자를 합하면 같은 상수가 된다. 마방진은 1부터 `n²`까지의 정수를 가진다. 모든 행, 열 및 대각선의 고정 합을 마법 상수 또는 마법합이라고 한다. 이를 M이라는 문자로 표시한다. 전형적인 마방진의 마법 상수는 전적으로 `n`의 값에 따라 결정된다. 따라서 마법합의 값은 다음 공식을 사용하여 계산한다:

- M = `n(n² + 1)/2`

- 이는 다른 차수의 마방진을 만드는 데 사용되는 마방진 공식이다. (`n²` + 1)에서 각 위치의 숫자를 빼면, 또 다른 마방진을 만들 수 있는데, 이를 서로 보완적인 마방진(complementary magic square)이라고 부른다. 그리고 1부터 시작하여 연속된 자연수들로 이루어진 마방진을 정규(normal) 마방진이라고 알려져 있다.

# 마방진을 푸는 방법

위에서 언급한 바와 같이, 마법합의 공식은 n(n² + 1)/2이다.\
3차 마방진에 경우, n = 3 을 대입하여 마법합의 값을 구한다면 3×3 마방진을 쉽게 형성할 수 있다.

`n = 3`일 경우, 마법합 = 3(3\*3 + 1)/2 = 3(9 + 1)/2 = (3 × 10)/2 = 15이다.\
이제, 우리는 각 행, 열, 대각선 방향으로 더한 숫자들의 합이 15와 동일하도록 각각의 위치에 숫자를 배치해야 한다.

## 3차 마방진 만들기 요령

`x`를 마방진의 차수라고 하자.

이 경우, `x = 3`이다.

`x`와 `y`의 곱이 마법합의 값인 15가 되는 또 다른 숫자 `y`를 생각해 보자.

그렇다면, `y = 5 {xy = (3)(5) = 15}`

y의 값은 항상 정사각형 정중앙에 있어야 하고, x의 값은 y의 값 왼쪽 셀에 있어야 한다.\
x 위의 셀은 아래의 이미지처럼 y – 1를 가진다:

![magic-square-formula](https://user-images.githubusercontent.com/106215707/192823452-3eea7074-c8f0-4b30-9e83-ef7fb6641a01.png)
![magic-square-1](https://user-images.githubusercontent.com/106215707/192823521-c992c61b-055a-4af8-b697-71fb0ed22566.png)
![magic-square-2](https://user-images.githubusercontent.com/106215707/192823583-8a375043-21d7-4a74-b2d8-119a6ca727eb.png)

위 마방진의 서로 보완적인 마방진(complementary magic square)을 만들자.

`(n² + 1) = 32 + 1 = 9 + 1 = 10`

이제, (n² + 1)의 값인 10에서 각 숫자를 빼라.

- 첫 번째 행의 숫자들:

  - 10 – 4 = 6
  - 10 – 3 = 7
  - 10 – 8 = 2

- 두 번째 행의 숫자들:

  - 10 – 9 = 1 ,
  - 10 – 5 = 5 ,
  - 10 – 1 = 9

- 세 번째 행의 숫자들:
  - 10 – 2 = 8 ,
  - 10 – 7 = 3 ,
  - 10 – 6 = 4

![magic-square-3](https://user-images.githubusercontent.com/106215707/192823650-21655cfe-0b8f-4bcb-b7d0-76280770c615.png)

# 참조

## 웹사이트

- [Byjus](https://byjus.com/maths/magic-square/)
- [geeksforgeeks](https://www.geeksforgeeks.org/magic-square/)

## The Algorithms 페이지

- [마방진](https://the-algorithms.com/ko/algorithm/magic-square)
